' filepath: c:\Users\dpascoal\Documents\Projects\DHLAllinone\src\scripts\sap-script-labels.vbs
' sap-script-labels.vbs - Print labels from SAP

On Error Resume Next

' Set scripting mode to true
Set WSHShell = CreateObject("WScript.Shell")

' Disable SAP GUI scripting warnings in registry
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAttach", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnConnection", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAllowListRequired", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\UseAllowList", 0, "REG_DWORD"

' Declare log file object and path
Dim logFile, logFilePath

' Get command line arguments
barcodeId = WScript.Arguments.Item(0)   ' Changed to barcodeId instead of equipmentNumber
printerName = WScript.Arguments.Item(1) ' Printer name (not used now as we're hardcoding it)
quantity = WScript.Arguments.Item(2)    ' Quantity to print

' Initialize log file if path is provided
If WScript.Arguments.Count > 3 Then
    logFilePath = WScript.Arguments.Item(3)
    ' Try to open the log file in append mode (8)
    On Error Resume Next
    Set fso = CreateObject("Scripting.FileSystemObject")
    Set logFile = fso.OpenTextFile(logFilePath, 8, True)
    
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Could not open log file: " & Err.Description
        Err.Clear
        Set logFile = Nothing
    Else
        ' Log script start
        LogToFile "========================================="
        LogToFile "Labels Script Started at " & Now
        LogToFile "Script: " & WScript.ScriptName
        LogToFile "Barcode ID: " & barcodeId
        LogToFile "Printer: " & printerName
        LogToFile "Quantity: " & quantity
        LogToFile "========================================="
    End If
End If

' Function to log message to file
Sub LogToFile(message)
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.WriteLine Now & " - [" & WScript.ScriptName & "] - " & message
    End If
End Sub

' Function to log message to both console and file
Sub LogMessage(message)
    WScript.Echo message
    LogToFile message
End Sub

' Initialize SAP connection
If Not IsObject(application) Then
   Set SapGuiAuto = GetObject("SAPGUI")
   Set application = SapGuiAuto.GetScriptingEngine
End If
If Not IsObject(connection) Then
   Set connection = application.Children(0)
End If
If Not IsObject(session) Then
   Set session = connection.Children(0)
End If
If IsObject(WScript) Then
   WScript.ConnectObject session, "on"
   WScript.ConnectObject application, "on"
End If

' Handle security dialog if needed
Sub HandleSecurityDialog()
    Dim shell, timeout, dialogFound
    Set shell = CreateObject("WScript.Shell")
    timeout = 0
    dialogFound = False
    
    Do While timeout < 10
        If shell.AppActivate("SAP GUI Security") Then
            WScript.Sleep 500
            shell.SendKeys " "  ' Press space to check "Remember my decision"
            WScript.Sleep 200
            shell.SendKeys "{ENTER}"  ' Press Enter to click Allow
            dialogFound = True
            Exit Do
        End If
        WScript.Sleep 500
        timeout = timeout + 1
    Loop
End Sub

' Call security dialog handler
HandleSecurityDialog()

' Execute the SAP commands for label printing
session.findById("wnd[0]").maximize
session.findById("wnd[0]/tbar[0]/okcd").text = "zbcp"
session.findById("wnd[0]").sendVKey 0
session.findById("wnd[0]/usr/ctxtGV_BARCODE").text = barcodeId  ' Using barcodeId instead of equipment number
session.findById("wnd[0]/usr/txtGV_QUANTITY").text = quantity
session.findById("wnd[0]/usr/cmbZBC_LBL_DEF-BCLABELID").key = "15"
session.findById("wnd[0]/usr/cmbZBC_LBL_PRT-NAME").key = "ZLOCL_TSC_SF600"  ' Hardcoded printer name
session.findById("wnd[0]/usr/ctxtGV_BARCODE").caretPosition = 10
session.findById("wnd[0]").sendVKey 0

' Return success
LogMessage "Labels printed successfully"

' Navigate back
session.findById("wnd[0]/tbar[0]/btn[3]").press

' Add at the end of your script before it exits
Sub CloseLogFile()
    On Error Resume Next
    If Not logFile Is Nothing Then
        LogToFile "Script ended at " & Now
        LogToFile "========================================="
        logFile.Close
        Set logFile = Nothing
    End If
End Sub

' At the end of the script, add:
CloseLogFile()